package gov.va.genisis2Test.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.when;

import org.junit.Test;

import gov.va.genisis2.dao.impl.LookUpDao;
import gov.va.genisis2.service.impl.LookUpService;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;



/**
 * The Class LookUpServiceTest.
 *
 * @author1 Prasad Thummalapalli
 * 
 *          The Class LookUpServiceTest.
 * 
 *          Description: In this LookUpServiceTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class LookUpServiceTest extends AbstractMockMvcTests {
	
	/**
	 * This method is used to TestLookUpService.
	 */
	@Test
	public void testLookUpService() {
		LookUpService lookUpService = new LookUpService();
		assertNull(lookUpService.getLookUpDao());
		
		// create mock object
		LookUpDao mockLookUpDao = getMockLookUpDao();
		lookUpService.setLookUpDao(mockLookUpDao);
		
		//Draft // 1
		String statusDesc = "Draft";
		int statusId = 1;
		
		when(mockLookUpDao.getStatusId(statusDesc)).thenReturn(statusId);
		int lookUpIndex = lookUpService.getStatusId(statusDesc);
		assertEquals(statusId, lookUpIndex);
	}
}